/**
*
* MD Gallery v1 [build1.0]
* Copyright (c) 2007 D. Molanphy, Molanphy Design
* 
* This software may be used in personal and commercial projects provided the 
* source code retains the above copyright notice.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT 
* NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
* WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*
*
*/

//==============================================================================================
//---- FUNCTION TO PLACE BUTTONS (IF NEEDED)
//==============================================================================================
function placeButtons():Void {
	if (!mainTL.gallery_mc.buttons_mc) {
		mainTL.gallery_mc.attachMovie("mc.buttons", "buttons_mc", mainTL.gallery_mc.getNextHighestDepth(), {_alpha:0});
		var buttons:MovieClip = mainTL.gallery_mc.buttons_mc;
	}
	
	if (maxRows * maxColumns < library_obj.numNodes) {
	
		// place them
		buttons.alphaTo(100, animSpeed, 'easeInOutSine');
		buttons._x 				= mainTL.gallery_mc.mask_mc._width + 10;
		buttons.up._height 		= buttons.down._height = (mainTL.gallery_mc.mask_mc._height/2) - (thumbnailSpacer/2);
		buttons.down._y 		= buttons.up._height;
		buttons.arrow_down._y 	= mainTL.gallery_mc.mask_mc._height - thumbnailSpacer - 5;

		// set initial alpha and color
		buttons.up._alpha = buttons.down._alpha = 0;	
		buttons.arrow_down.colorTo(mainTL.linkColor, 0);
		buttons.arrow_up.colorTo(mainTL.linkColor, 0);


		// store some info to avoid extra typing ;)
		var galleryH:Number = mainTL.gallery_mc._height;					// determines TOTAL height of gallery
		var maskH:Number 	= mainTL.gallery_mc.mask_mc._height;			// determines height of mask
	
		// activate them
		// DOWN
		buttons.down.onRollOver = function():Void {
			this.alphaTo(100, .5, 'easeOutExpo');
			buttons.arrow_down.colorTo(mainTL.activeColor, 0, "linear");
		}

		buttons.down.onRollOut = function():Void {
			this.alphaTo(0, 1, 'easeOutExpo');
			buttons.arrow_down.colorTo(mainTL.linkColor, animSpeed, "easeOutSine");
		}
	
	
		buttons.down.onRelease = buttons.down_mc.onReleaseOutside = function():Void {
			var thumbsY:Number 	= mainTL.gallery_mc.thumbs_mc._y;											// determines _y position of thumbs_mc
			var thumbH:Number	= mainTL.gallery_mc.thumbs_mc.thumb_0._height + thumbnailSpacer;			// determines height of one thumbnail
			var newY:Number = thumbsY - thumbH; 

			if (newY >=  -(galleryH - maskH) - (thumbnailSpacer * maxRows)) {
				if (mainTL.gallery_mc.thumbs_mc.isTweening() == false) {
					mainTL.gallery_mc.thumbs_mc.slideTo(null, newY, .5, 'easeOutExpo', null, checkButtonStatus);
				}
			}
		}

		// UP
		buttons.up.onRollOver = function():Void {
			this.alphaTo(100, .5, 'easeOutExpo');
			buttons.arrow_up.colorTo(mainTL.activeColor, 0, "linear");
		}

		buttons.up.onRollOut = function():Void {
			this.alphaTo(0, 1, 'easeOutExpo');
			buttons.arrow_up.colorTo(mainTL.linkColor, animSpeed, "easeOutSine");
		}

		buttons.up.onRelease = buttons.up_mc.onReleaseOutside = function():Void {
			var thumbsY:Number 	= mainTL.gallery_mc.thumbs_mc._y;											// determines _y position of thumbs_mc
			var thumbH:Number	= mainTL.gallery_mc.thumbs_mc.thumb_0._height + thumbnailSpacer;			// determines height of one thumbnail
			var newY:Number = thumbsY + thumbH; 

			if (newY <= 0) {
				if (mainTL.gallery_mc.thumbs_mc.isTweening() == false) {
					mainTL.gallery_mc.thumbs_mc.slideTo(null, newY, .5, 'easeOutExpo', null, checkButtonStatus);
				}
			}
		}
	
		checkButtonStatus();
	}
};

//==============================================================================================
//---- FUNCTION TO CHECK BUTTON STATUS
//==============================================================================================
function checkButtonStatus():Void {
	var buttons:MovieClip 	= mainTL.gallery_mc.buttons_mc;
	var thumbsY:Number 		= mainTL.gallery_mc.thumbs_mc._y;				// determines _y position of thumbs_mc
	var galleryH:Number 	= mainTL.gallery_mc.thumbs_mc._height;			// determines TOTAL height of gallery
	var maskH:Number 		= mainTL.gallery_mc.mask_mc._height;			// determines height of mask

	if (thumbsY <= -(galleryH - maskH)) {
		buttons.down.enabled = false;
		buttons.down.alphaTo(20, .5, 'easeOutExpo');
		buttons.arrow_down.alphaTo(10, .5, 'easeOutExpo');
	} else {
		buttons.down.enabled = true;
		buttons.down.alphaTo(100, 1, 'easeOutExpo');
		buttons.arrow_down.alphaTo(100, 1, 'easeOutExpo');
		buttons.arrow_down.colorTo(linkColor, 0);
	}
	
	if (thumbsY == 0) {
		buttons.up.enabled = false;
		buttons.up.alphaTo(20, .5, 'easeOutExpo');
		buttons.arrow_up.alphaTo(10, .5, 'easeOutExpo');
	} else {
		buttons.up.enabled = true;
		buttons.up.alphaTo(100, 1, 'easeOutExpo');
		buttons.arrow_up.alphaTo(100, 1, 'easeOutExpo');
		buttons.arrow_down.colorTo(linkColor, 0);
	}
};

//==============================================================================================
//---- FUNCTION TO ENABLE/DISABLE BUTTONS
//==============================================================================================
function enableButtons(condition:Boolean):Boolean {
	mainTL.gallery_mc.buttons_mc.down.enabled 	= condition;
	mainTL.gallery_mc.buttons_mc.up.enabled 	= condition;
	return condition;
}

